package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.AccessPackageResourceRoleScope;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class AccessPackageResourceRoleScopeRequest extends EntityRequest<AccessPackageResourceRoleScope> {

    public AccessPackageResourceRoleScopeRequest(ContextPath contextPath) {
        super(AccessPackageResourceRoleScope.class, contextPath, SchemaInfo.INSTANCE);
    }

    public AccessPackageResourceRoleRequest accessPackageResourceRole() {
        return new AccessPackageResourceRoleRequest(contextPath.addSegment("accessPackageResourceRole"));
    }

    public AccessPackageResourceScopeRequest accessPackageResourceScope() {
        return new AccessPackageResourceScopeRequest(contextPath.addSegment("accessPackageResourceScope"));
    }

}
