package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.AccessPackageResource;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceRoleCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceScopeCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class AccessPackageResourceRequest extends EntityRequest<AccessPackageResource> {

    public AccessPackageResourceRequest(ContextPath contextPath) {
        super(AccessPackageResource.class, contextPath, SchemaInfo.INSTANCE);
    }

    public AccessPackageResourceScopeCollectionRequest accessPackageResourceScopes() {
        return new AccessPackageResourceScopeCollectionRequest(
                        contextPath.addSegment("accessPackageResourceScopes"));
    }

    public AccessPackageResourceScopeRequest accessPackageResourceScopes(String id) {
        return new AccessPackageResourceScopeRequest(contextPath.addSegment("accessPackageResourceScopes").addKeys(new NameValue(id.toString())));
    }

    public AccessPackageResourceRoleCollectionRequest accessPackageResourceRoles() {
        return new AccessPackageResourceRoleCollectionRequest(
                        contextPath.addSegment("accessPackageResourceRoles"));
    }

    public AccessPackageResourceRoleRequest accessPackageResourceRoles(String id) {
        return new AccessPackageResourceRoleRequest(contextPath.addSegment("accessPackageResourceRoles").addKeys(new NameValue(id.toString())));
    }

}
