package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.AccessPackageCatalog;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceRoleCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageResourceScopeCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class AccessPackageCatalogRequest extends EntityRequest<AccessPackageCatalog> {

    public AccessPackageCatalogRequest(ContextPath contextPath) {
        super(AccessPackageCatalog.class, contextPath, SchemaInfo.INSTANCE);
    }

    public AccessPackageResourceCollectionRequest accessPackageResources() {
        return new AccessPackageResourceCollectionRequest(
                        contextPath.addSegment("accessPackageResources"));
    }

    public AccessPackageResourceRequest accessPackageResources(String id) {
        return new AccessPackageResourceRequest(contextPath.addSegment("accessPackageResources").addKeys(new NameValue(id.toString())));
    }

    public AccessPackageResourceRoleCollectionRequest accessPackageResourceRoles() {
        return new AccessPackageResourceRoleCollectionRequest(
                        contextPath.addSegment("accessPackageResourceRoles"));
    }

    public AccessPackageResourceRoleRequest accessPackageResourceRoles(String id) {
        return new AccessPackageResourceRoleRequest(contextPath.addSegment("accessPackageResourceRoles").addKeys(new NameValue(id.toString())));
    }

    public AccessPackageResourceScopeCollectionRequest accessPackageResourceScopes() {
        return new AccessPackageResourceScopeCollectionRequest(
                        contextPath.addSegment("accessPackageResourceScopes"));
    }

    public AccessPackageResourceScopeRequest accessPackageResourceScopes(String id) {
        return new AccessPackageResourceScopeRequest(contextPath.addSegment("accessPackageResourceScopes").addKeys(new NameValue(id.toString())));
    }

    public AccessPackageCollectionRequest accessPackages() {
        return new AccessPackageCollectionRequest(
                        contextPath.addSegment("accessPackages"));
    }

    public AccessPackageRequest accessPackages(String id) {
        return new AccessPackageRequest(contextPath.addSegment("accessPackages").addKeys(new NameValue(id.toString())));
    }

}
