package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.AccessPackageAssignmentResourceRole;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageAssignmentCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class AccessPackageAssignmentResourceRoleRequest extends EntityRequest<AccessPackageAssignmentResourceRole> {

    public AccessPackageAssignmentResourceRoleRequest(ContextPath contextPath) {
        super(AccessPackageAssignmentResourceRole.class, contextPath, SchemaInfo.INSTANCE);
    }

    public AccessPackageResourceScopeRequest accessPackageResourceScope() {
        return new AccessPackageResourceScopeRequest(contextPath.addSegment("accessPackageResourceScope"));
    }

    public AccessPackageResourceRoleRequest accessPackageResourceRole() {
        return new AccessPackageResourceRoleRequest(contextPath.addSegment("accessPackageResourceRole"));
    }

    public AccessPackageSubjectRequest accessPackageSubject() {
        return new AccessPackageSubjectRequest(contextPath.addSegment("accessPackageSubject"));
    }

    public AccessPackageAssignmentCollectionRequest accessPackageAssignments() {
        return new AccessPackageAssignmentCollectionRequest(
                        contextPath.addSegment("accessPackageAssignments"));
    }

    public AccessPackageAssignmentRequest accessPackageAssignments(String id) {
        return new AccessPackageAssignmentRequest(contextPath.addSegment("accessPackageAssignments").addKeys(new NameValue(id.toString())));
    }

}
