package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.AccessPackageAssignmentRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class AccessPackageAssignmentRequestRequest extends EntityRequest<AccessPackageAssignmentRequest> {

    public AccessPackageAssignmentRequestRequest(ContextPath contextPath) {
        super(AccessPackageAssignmentRequest.class, contextPath, SchemaInfo.INSTANCE);
    }

    public AccessPackageRequest accessPackage() {
        return new AccessPackageRequest(contextPath.addSegment("accessPackage"));
    }

    public odata.msgraph.client.beta.entity.request.AccessPackageAssignmentRequest accessPackageAssignment() {
        return new odata.msgraph.client.beta.entity.request.AccessPackageAssignmentRequest(contextPath.addSegment("accessPackageAssignment"));
    }

    public AccessPackageSubjectRequest requestor() {
        return new AccessPackageSubjectRequest(contextPath.addSegment("requestor"));
    }

    @Action(name = "Cancel")
    @JsonIgnore
    public ActionRequestNoReturn cancel() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.Cancel"), _parameters);
    }

}
