package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.AccessPackageAssignment;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageAssignmentRequestCollectionRequest;
import odata.msgraph.client.beta.entity.collection.request.AccessPackageAssignmentResourceRoleCollectionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class AccessPackageAssignmentRequest extends EntityRequest<AccessPackageAssignment> {

    public AccessPackageAssignmentRequest(ContextPath contextPath) {
        super(AccessPackageAssignment.class, contextPath, SchemaInfo.INSTANCE);
    }

    public AccessPackageRequest accessPackage() {
        return new AccessPackageRequest(contextPath.addSegment("accessPackage"));
    }

    public AccessPackageAssignmentPolicyRequest accessPackageAssignmentPolicy() {
        return new AccessPackageAssignmentPolicyRequest(contextPath.addSegment("accessPackageAssignmentPolicy"));
    }

    public AccessPackageSubjectRequest target() {
        return new AccessPackageSubjectRequest(contextPath.addSegment("target"));
    }

    public AccessPackageAssignmentRequestCollectionRequest accessPackageAssignmentRequests() {
        return new AccessPackageAssignmentRequestCollectionRequest(
                        contextPath.addSegment("accessPackageAssignmentRequests"));
    }

    public AccessPackageAssignmentRequestRequest accessPackageAssignmentRequests(String id) {
        return new AccessPackageAssignmentRequestRequest(contextPath.addSegment("accessPackageAssignmentRequests").addKeys(new NameValue(id.toString())));
    }

    public AccessPackageAssignmentResourceRoleCollectionRequest accessPackageAssignmentResourceRoles() {
        return new AccessPackageAssignmentResourceRoleCollectionRequest(
                        contextPath.addSegment("accessPackageAssignmentResourceRoles"));
    }

    public AccessPackageAssignmentResourceRoleRequest accessPackageAssignmentResourceRoles(String id) {
        return new AccessPackageAssignmentResourceRoleRequest(contextPath.addSegment("accessPackageAssignmentResourceRoles").addKeys(new NameValue(id.toString())));
    }

}
