package odata.msgraph.client.beta.entity.request;

import com.fasterxml.jackson.annotation.JsonIgnoreType;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.EntityRequest;

import odata.msgraph.client.beta.entity.AccessPackageAssignmentPolicy;
import odata.msgraph.client.beta.schema.SchemaInfo;

@JsonIgnoreType
public class AccessPackageAssignmentPolicyRequest extends EntityRequest<AccessPackageAssignmentPolicy> {

    public AccessPackageAssignmentPolicyRequest(ContextPath contextPath) {
        super(AccessPackageAssignmentPolicy.class, contextPath, SchemaInfo.INSTANCE);
    }

    public AccessPackageRequest accessPackage() {
        return new AccessPackageRequest(contextPath.addSegment("accessPackage"));
    }

    public AccessPackageCatalogRequest accessPackageCatalog() {
        return new AccessPackageCatalogRequest(contextPath.addSegment("accessPackageCatalog"));
    }

}
