package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.complex.Json;
import odata.msgraph.client.beta.entity.WorkbookTableColumn;
import odata.msgraph.client.beta.entity.request.WorkbookTableColumnRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class WorkbookTableColumnCollectionRequest extends CollectionPageEntityRequest<WorkbookTableColumn, WorkbookTableColumnRequest>{

    protected ContextPath contextPath;

    public WorkbookTableColumnCollectionRequest(ContextPath contextPath) {
        super(contextPath, WorkbookTableColumn.class, cp -> new WorkbookTableColumnRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }


    @Action(name = "add")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookTableColumn> add(Integer index, Json values, String name) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("index", "Edm.Int32", index)
            .put("values", "microsoft.graph.Json", values)
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookTableColumn>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.add"), WorkbookTableColumn.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "itemAt")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookTableColumn> itemAt(Integer index) {
        Preconditions.checkNotNull(index, "index cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("index", "Edm.Int32", index)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookTableColumn>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.itemAt"), WorkbookTableColumn.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "count")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Integer> count() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<Integer>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.count"), Integer.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

}
