package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.WorkbookRangeView;
import odata.msgraph.client.beta.entity.request.WorkbookRangeViewRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class WorkbookRangeViewCollectionRequest extends CollectionPageEntityRequest<WorkbookRangeView, WorkbookRangeViewRequest>{

    protected ContextPath contextPath;

    public WorkbookRangeViewCollectionRequest(ContextPath contextPath) {
        super(contextPath, WorkbookRangeView.class, cp -> new WorkbookRangeViewRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public WorkbookRangeViewCollectionRequest rows() {
        return new WorkbookRangeViewCollectionRequest(contextPath.addSegment("rows"));
    }

    public WorkbookRangeViewRequest rows(String id) {
        return new WorkbookRangeViewRequest(contextPath.addSegment("rows").addKeys(new NameValue(id.toString())));
    }

    @Function(name = "itemAt")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookRangeView> itemAt(Integer index) {
        Preconditions.checkNotNull(index, "index cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("index", "Edm.Int32", index)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookRangeView>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.itemAt"), WorkbookRangeView.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
