package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.WorkbookPivotTable;
import odata.msgraph.client.beta.entity.request.WorkbookPivotTableRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class WorkbookPivotTableCollectionRequest extends CollectionPageEntityRequest<WorkbookPivotTable, WorkbookPivotTableRequest>{

    protected ContextPath contextPath;

    public WorkbookPivotTableCollectionRequest(ContextPath contextPath) {
        super(contextPath, WorkbookPivotTable.class, cp -> new WorkbookPivotTableRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }


    @Action(name = "refreshAll")
    @JsonIgnore
    public ActionRequestNoReturn refreshAll() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.refreshAll"), _parameters);
    }

}
