package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.complex.Json;
import odata.msgraph.client.beta.entity.WorkbookNamedItem;
import odata.msgraph.client.beta.entity.request.WorkbookNamedItemRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class WorkbookNamedItemCollectionRequest extends CollectionPageEntityRequest<WorkbookNamedItem, WorkbookNamedItemRequest>{

    protected ContextPath contextPath;

    public WorkbookNamedItemCollectionRequest(ContextPath contextPath) {
        super(contextPath, WorkbookNamedItem.class, cp -> new WorkbookNamedItemRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }


    @Action(name = "add")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookNamedItem> add(String name, Json reference, String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("reference", "microsoft.graph.Json", reference)
            .put("comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookNamedItem>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.add"), WorkbookNamedItem.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "addFormulaLocal")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<WorkbookNamedItem> addFormulaLocal(String name, String formula, String comment) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("name", "Edm.String", Checks.checkIsAscii(name))
            .put("formula", "Edm.String", Checks.checkIsAscii(formula))
            .put("comment", "Edm.String", Checks.checkIsAscii(comment))
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<WorkbookNamedItem>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.addFormulaLocal"), WorkbookNamedItem.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
