package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.WorkbookComment;
import odata.msgraph.client.beta.entity.request.WorkbookCommentReplyRequest;
import odata.msgraph.client.beta.entity.request.WorkbookCommentRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class WorkbookCommentCollectionRequest extends CollectionPageEntityRequest<WorkbookComment, WorkbookCommentRequest>{

    protected ContextPath contextPath;

    public WorkbookCommentCollectionRequest(ContextPath contextPath) {
        super(contextPath, WorkbookComment.class, cp -> new WorkbookCommentRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public WorkbookCommentReplyCollectionRequest replies() {
        return new WorkbookCommentReplyCollectionRequest(contextPath.addSegment("replies"));
    }

    public WorkbookCommentReplyRequest replies(String id) {
        return new WorkbookCommentReplyRequest(contextPath.addSegment("replies").addKeys(new NameValue(id.toString())));
    }

}
