package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.WorkbookChartSeries;
import odata.msgraph.client.beta.entity.request.WorkbookChartPointRequest;
import odata.msgraph.client.beta.entity.request.WorkbookChartSeriesRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class WorkbookChartSeriesCollectionRequest extends CollectionPageEntityRequest<WorkbookChartSeries, WorkbookChartSeriesRequest>{

    protected ContextPath contextPath;

    public WorkbookChartSeriesCollectionRequest(ContextPath contextPath) {
        super(contextPath, WorkbookChartSeries.class, cp -> new WorkbookChartSeriesRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }


    public WorkbookChartPointCollectionRequest points() {
        return new WorkbookChartPointCollectionRequest(contextPath.addSegment("points"));
    }

    public WorkbookChartPointRequest points(String id) {
        return new WorkbookChartPointRequest(contextPath.addSegment("points").addKeys(new NameValue(id.toString())));
    }

    @Function(name = "itemAt")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<WorkbookChartSeries> itemAt(Integer index) {
        Preconditions.checkNotNull(index, "index cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("index", "Edm.Int32", index)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<WorkbookChartSeries>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.itemAt"), WorkbookChartSeries.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "count")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Integer> count() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<Integer>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.count"), Integer.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

}
