package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.WindowsProtectionState;
import odata.msgraph.client.beta.entity.request.WindowsDeviceMalwareStateRequest;
import odata.msgraph.client.beta.entity.request.WindowsProtectionStateRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class WindowsProtectionStateCollectionRequest extends CollectionPageEntityRequest<WindowsProtectionState, WindowsProtectionStateRequest>{

    protected ContextPath contextPath;

    public WindowsProtectionStateCollectionRequest(ContextPath contextPath) {
        super(contextPath, WindowsProtectionState.class, cp -> new WindowsProtectionStateRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public WindowsDeviceMalwareStateCollectionRequest detectedMalwareState() {
        return new WindowsDeviceMalwareStateCollectionRequest(contextPath.addSegment("detectedMalwareState"));
    }

    public WindowsDeviceMalwareStateRequest detectedMalwareState(String id) {
        return new WindowsDeviceMalwareStateRequest(contextPath.addSegment("detectedMalwareState").addKeys(new NameValue(id.toString())));
    }

}
