package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.WindowsMalwareInformation;
import odata.msgraph.client.beta.entity.request.WindowsMalwareInformationRequest;
import odata.msgraph.client.beta.entity.request.WindowsProtectionStateRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class WindowsMalwareInformationCollectionRequest extends CollectionPageEntityRequest<WindowsMalwareInformation, WindowsMalwareInformationRequest>{

    protected ContextPath contextPath;

    public WindowsMalwareInformationCollectionRequest(ContextPath contextPath) {
        super(contextPath, WindowsMalwareInformation.class, cp -> new WindowsMalwareInformationRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public WindowsProtectionStateCollectionRequest windowsDevicesProtectionState() {
        return new WindowsProtectionStateCollectionRequest(contextPath.addSegment("windowsDevicesProtectionState"));
    }

    public WindowsProtectionStateRequest windowsDevicesProtectionState(String id) {
        return new WindowsProtectionStateRequest(contextPath.addSegment("windowsDevicesProtectionState").addKeys(new NameValue(id.toString())));
    }

}
