package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.WindowsFeatureUpdateProfile;
import odata.msgraph.client.beta.entity.request.WindowsFeatureUpdateProfileAssignmentRequest;
import odata.msgraph.client.beta.entity.request.WindowsFeatureUpdateProfileRequest;
import odata.msgraph.client.beta.entity.request.WindowsUpdateStateRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class WindowsFeatureUpdateProfileCollectionRequest extends CollectionPageEntityRequest<WindowsFeatureUpdateProfile, WindowsFeatureUpdateProfileRequest>{

    protected ContextPath contextPath;

    public WindowsFeatureUpdateProfileCollectionRequest(ContextPath contextPath) {
        super(contextPath, WindowsFeatureUpdateProfile.class, cp -> new WindowsFeatureUpdateProfileRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public WindowsFeatureUpdateProfileAssignmentCollectionRequest assignments() {
        return new WindowsFeatureUpdateProfileAssignmentCollectionRequest(contextPath.addSegment("assignments"));
    }

    public WindowsFeatureUpdateProfileAssignmentRequest assignments(String id) {
        return new WindowsFeatureUpdateProfileAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }

    public WindowsUpdateStateCollectionRequest deviceUpdateStates() {
        return new WindowsUpdateStateCollectionRequest(contextPath.addSegment("deviceUpdateStates"));
    }

    public WindowsUpdateStateRequest deviceUpdateStates(String id) {
        return new WindowsUpdateStateRequest(contextPath.addSegment("deviceUpdateStates").addKeys(new NameValue(id.toString())));
    }

}
