package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.WindowsDefenderApplicationControlSupplementalPolicy;
import odata.msgraph.client.beta.entity.request.WindowsDefenderApplicationControlSupplementalPolicyAssignmentRequest;
import odata.msgraph.client.beta.entity.request.WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusRequest;
import odata.msgraph.client.beta.entity.request.WindowsDefenderApplicationControlSupplementalPolicyRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class WindowsDefenderApplicationControlSupplementalPolicyCollectionRequest extends CollectionPageEntityRequest<WindowsDefenderApplicationControlSupplementalPolicy, WindowsDefenderApplicationControlSupplementalPolicyRequest>{

    protected ContextPath contextPath;

    public WindowsDefenderApplicationControlSupplementalPolicyCollectionRequest(ContextPath contextPath) {
        super(contextPath, WindowsDefenderApplicationControlSupplementalPolicy.class, cp -> new WindowsDefenderApplicationControlSupplementalPolicyRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public WindowsDefenderApplicationControlSupplementalPolicyAssignmentCollectionRequest assignments() {
        return new WindowsDefenderApplicationControlSupplementalPolicyAssignmentCollectionRequest(contextPath.addSegment("assignments"));
    }

    public WindowsDefenderApplicationControlSupplementalPolicyAssignmentRequest assignments(String id) {
        return new WindowsDefenderApplicationControlSupplementalPolicyAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }


    public WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusCollectionRequest deviceStatuses() {
        return new WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusCollectionRequest(contextPath.addSegment("deviceStatuses"));
    }

    public WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusRequest deviceStatuses(String id) {
        return new WindowsDefenderApplicationControlSupplementalPolicyDeploymentStatusRequest(contextPath.addSegment("deviceStatuses").addKeys(new NameValue(id.toString())));
    }

}
