package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.complex.HasPayloadLinkResultItem;
import odata.msgraph.client.beta.entity.WindowsAutopilotDeploymentProfile;
import odata.msgraph.client.beta.entity.request.WindowsAutopilotDeploymentProfileAssignmentRequest;
import odata.msgraph.client.beta.entity.request.WindowsAutopilotDeploymentProfileRequest;
import odata.msgraph.client.beta.entity.request.WindowsAutopilotDeviceIdentityRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class WindowsAutopilotDeploymentProfileCollectionRequest extends CollectionPageEntityRequest<WindowsAutopilotDeploymentProfile, WindowsAutopilotDeploymentProfileRequest>{

    protected ContextPath contextPath;

    public WindowsAutopilotDeploymentProfileCollectionRequest(ContextPath contextPath) {
        super(contextPath, WindowsAutopilotDeploymentProfile.class, cp -> new WindowsAutopilotDeploymentProfileRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public WindowsAutopilotDeviceIdentityCollectionRequest assignedDevices() {
        return new WindowsAutopilotDeviceIdentityCollectionRequest(contextPath.addSegment("assignedDevices"));
    }

    public WindowsAutopilotDeviceIdentityRequest assignedDevices(String id) {
        return new WindowsAutopilotDeviceIdentityRequest(contextPath.addSegment("assignedDevices").addKeys(new NameValue(id.toString())));
    }

    public WindowsAutopilotDeploymentProfileAssignmentCollectionRequest assignments() {
        return new WindowsAutopilotDeploymentProfileAssignmentCollectionRequest(contextPath.addSegment("assignments"));
    }

    public WindowsAutopilotDeploymentProfileAssignmentRequest assignments(String id) {
        return new WindowsAutopilotDeploymentProfileAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "hasPayloadLinks")
    @JsonIgnore
    public CollectionPageNonEntityRequest<HasPayloadLinkResultItem> hasPayloadLinks(List<String> payloadIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("payloadIds", "Collection(Edm.String)", Checks.checkIsAscii(payloadIds))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.hasPayloadLinks"), HasPayloadLinkResultItem.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
