package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Vendor;
import odata.msgraph.client.beta.entity.request.PictureRequest;
import odata.msgraph.client.beta.entity.request.VendorRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class VendorCollectionRequest extends CollectionPageEntityRequest<Vendor, VendorRequest>{

    protected ContextPath contextPath;

    public VendorCollectionRequest(ContextPath contextPath) {
        super(contextPath, Vendor.class, cp -> new VendorRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public PictureCollectionRequest picture() {
        return new PictureCollectionRequest(contextPath.addSegment("picture"));
    }

    public PictureRequest picture(String id) {
        return new PictureRequest(contextPath.addSegment("picture").addKeys(new NameValue(id.toString())));
    }




}
