package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.UserInstallStateSummary;
import odata.msgraph.client.beta.entity.request.DeviceInstallStateRequest;
import odata.msgraph.client.beta.entity.request.UserInstallStateSummaryRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class UserInstallStateSummaryCollectionRequest extends CollectionPageEntityRequest<UserInstallStateSummary, UserInstallStateSummaryRequest>{

    protected ContextPath contextPath;

    public UserInstallStateSummaryCollectionRequest(ContextPath contextPath) {
        super(contextPath, UserInstallStateSummary.class, cp -> new UserInstallStateSummaryRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public DeviceInstallStateCollectionRequest deviceStates() {
        return new DeviceInstallStateCollectionRequest(contextPath.addSegment("deviceStates"));
    }

    public DeviceInstallStateRequest deviceStates(String id) {
        return new DeviceInstallStateRequest(contextPath.addSegment("deviceStates").addKeys(new NameValue(id.toString())));
    }

}
