package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.UserExperienceAnalyticsCategory;
import odata.msgraph.client.beta.entity.request.UserExperienceAnalyticsCategoryRequest;
import odata.msgraph.client.beta.entity.request.UserExperienceAnalyticsMetricRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class UserExperienceAnalyticsCategoryCollectionRequest extends CollectionPageEntityRequest<UserExperienceAnalyticsCategory, UserExperienceAnalyticsCategoryRequest>{

    protected ContextPath contextPath;

    public UserExperienceAnalyticsCategoryCollectionRequest(ContextPath contextPath) {
        super(contextPath, UserExperienceAnalyticsCategory.class, cp -> new UserExperienceAnalyticsCategoryRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public UserExperienceAnalyticsMetricCollectionRequest metricValues() {
        return new UserExperienceAnalyticsMetricCollectionRequest(contextPath.addSegment("metricValues"));
    }

    public UserExperienceAnalyticsMetricRequest metricValues(String id) {
        return new UserExperienceAnalyticsMetricRequest(contextPath.addSegment("metricValues").addKeys(new NameValue(id.toString())));
    }

}
