package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.User;
import odata.msgraph.client.beta.entity.request.AccessReviewInstanceRequest;
import odata.msgraph.client.beta.entity.request.AgreementAcceptanceRequest;
import odata.msgraph.client.beta.entity.request.AppConsentRequestRequest;
import odata.msgraph.client.beta.entity.request.AppRoleAssignmentRequest;
import odata.msgraph.client.beta.entity.request.ApprovalRequest;
import odata.msgraph.client.beta.entity.request.CalendarGroupRequest;
import odata.msgraph.client.beta.entity.request.CalendarRequest;
import odata.msgraph.client.beta.entity.request.ChatRequest;
import odata.msgraph.client.beta.entity.request.ContactFolderRequest;
import odata.msgraph.client.beta.entity.request.ContactRequest;
import odata.msgraph.client.beta.entity.request.DeviceEnrollmentConfigurationRequest;
import odata.msgraph.client.beta.entity.request.DeviceManagementTroubleshootingEventRequest;
import odata.msgraph.client.beta.entity.request.DeviceRequest;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;
import odata.msgraph.client.beta.entity.request.DriveRequest;
import odata.msgraph.client.beta.entity.request.EventRequest;
import odata.msgraph.client.beta.entity.request.ExtensionRequest;
import odata.msgraph.client.beta.entity.request.GroupRequest;
import odata.msgraph.client.beta.entity.request.LicenseDetailsRequest;
import odata.msgraph.client.beta.entity.request.MailFolderRequest;
import odata.msgraph.client.beta.entity.request.ManagedAppRegistrationRequest;
import odata.msgraph.client.beta.entity.request.ManagedDeviceRequest;
import odata.msgraph.client.beta.entity.request.MessageRequest;
import odata.msgraph.client.beta.entity.request.MobileAppIntentAndStateRequest;
import odata.msgraph.client.beta.entity.request.MobileAppTroubleshootingEventRequest;
import odata.msgraph.client.beta.entity.request.NotificationRequest;
import odata.msgraph.client.beta.entity.request.OnlineMeetingRequest;
import odata.msgraph.client.beta.entity.request.PersonRequest;
import odata.msgraph.client.beta.entity.request.ProfilePhotoRequest;
import odata.msgraph.client.beta.entity.request.ScopedRoleMembershipRequest;
import odata.msgraph.client.beta.entity.request.SiteRequest;
import odata.msgraph.client.beta.entity.request.TeamRequest;
import odata.msgraph.client.beta.entity.request.UserActivityRequest;
import odata.msgraph.client.beta.entity.request.UserRequest;
import odata.msgraph.client.beta.entity.request.WindowsInformationProtectionDeviceRegistrationRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class UserCollectionRequest extends CollectionPageEntityRequest<User, UserRequest>{

    protected ContextPath contextPath;

    public UserCollectionRequest(ContextPath contextPath) {
        super(contextPath, User.class, cp -> new UserRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }



    public AppRoleAssignmentCollectionRequest appRoleAssignments() {
        return new AppRoleAssignmentCollectionRequest(contextPath.addSegment("appRoleAssignments"));
    }

    public AppRoleAssignmentRequest appRoleAssignments(String id) {
        return new AppRoleAssignmentRequest(contextPath.addSegment("appRoleAssignments").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest createdObjects() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("createdObjects"));
    }

    public DirectoryObjectRequest createdObjects(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("createdObjects").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest directReports() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("directReports"));
    }

    public DirectoryObjectRequest directReports(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("directReports").addKeys(new NameValue(id.toString())));
    }

    public LicenseDetailsCollectionRequest licenseDetails() {
        return new LicenseDetailsCollectionRequest(contextPath.addSegment("licenseDetails"));
    }

    public LicenseDetailsRequest licenseDetails(String id) {
        return new LicenseDetailsRequest(contextPath.addSegment("licenseDetails").addKeys(new NameValue(id.toString())));
    }


    public DirectoryObjectCollectionRequest memberOf() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("memberOf"));
    }

    public DirectoryObjectRequest memberOf(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("memberOf").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest ownedDevices() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("ownedDevices"));
    }

    public DirectoryObjectRequest ownedDevices(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("ownedDevices").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest ownedObjects() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("ownedObjects"));
    }

    public DirectoryObjectRequest ownedObjects(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("ownedObjects").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest registeredDevices() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("registeredDevices"));
    }

    public DirectoryObjectRequest registeredDevices(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("registeredDevices").addKeys(new NameValue(id.toString())));
    }

    public ScopedRoleMembershipCollectionRequest scopedRoleMemberOf() {
        return new ScopedRoleMembershipCollectionRequest(contextPath.addSegment("scopedRoleMemberOf"));
    }

    public ScopedRoleMembershipRequest scopedRoleMemberOf(String id) {
        return new ScopedRoleMembershipRequest(contextPath.addSegment("scopedRoleMemberOf").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest transitiveMemberOf() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("transitiveMemberOf"));
    }

    public DirectoryObjectRequest transitiveMemberOf(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("transitiveMemberOf").addKeys(new NameValue(id.toString())));
    }


    public MessageCollectionRequest messages() {
        return new MessageCollectionRequest(contextPath.addSegment("messages"));
    }

    public MessageRequest messages(String id) {
        return new MessageRequest(contextPath.addSegment("messages").addKeys(new NameValue(id.toString())));
    }

    public GroupCollectionRequest joinedGroups() {
        return new GroupCollectionRequest(contextPath.addSegment("joinedGroups"));
    }

    public GroupRequest joinedGroups(String id) {
        return new GroupRequest(contextPath.addSegment("joinedGroups").addKeys(new NameValue(id.toString())));
    }

    public MailFolderCollectionRequest mailFolders() {
        return new MailFolderCollectionRequest(contextPath.addSegment("mailFolders"));
    }

    public MailFolderRequest mailFolders(String id) {
        return new MailFolderRequest(contextPath.addSegment("mailFolders").addKeys(new NameValue(id.toString())));
    }


    public CalendarCollectionRequest calendars() {
        return new CalendarCollectionRequest(contextPath.addSegment("calendars"));
    }

    public CalendarRequest calendars(String id) {
        return new CalendarRequest(contextPath.addSegment("calendars").addKeys(new NameValue(id.toString())));
    }

    public CalendarGroupCollectionRequest calendarGroups() {
        return new CalendarGroupCollectionRequest(contextPath.addSegment("calendarGroups"));
    }

    public CalendarGroupRequest calendarGroups(String id) {
        return new CalendarGroupRequest(contextPath.addSegment("calendarGroups").addKeys(new NameValue(id.toString())));
    }

    public EventCollectionRequest calendarView() {
        return new EventCollectionRequest(contextPath.addSegment("calendarView"));
    }

    public EventRequest calendarView(String id) {
        return new EventRequest(contextPath.addSegment("calendarView").addKeys(new NameValue(id.toString())));
    }

    public EventCollectionRequest events() {
        return new EventCollectionRequest(contextPath.addSegment("events"));
    }

    public EventRequest events(String id) {
        return new EventRequest(contextPath.addSegment("events").addKeys(new NameValue(id.toString())));
    }

    public PersonCollectionRequest people() {
        return new PersonCollectionRequest(contextPath.addSegment("people"));
    }

    public PersonRequest people(String id) {
        return new PersonRequest(contextPath.addSegment("people").addKeys(new NameValue(id.toString())));
    }

    public ContactCollectionRequest contacts() {
        return new ContactCollectionRequest(contextPath.addSegment("contacts"));
    }

    public ContactRequest contacts(String id) {
        return new ContactRequest(contextPath.addSegment("contacts").addKeys(new NameValue(id.toString())));
    }

    public ContactFolderCollectionRequest contactFolders() {
        return new ContactFolderCollectionRequest(contextPath.addSegment("contactFolders"));
    }

    public ContactFolderRequest contactFolders(String id) {
        return new ContactFolderRequest(contextPath.addSegment("contactFolders").addKeys(new NameValue(id.toString())));
    }



    public ProfilePhotoCollectionRequest photos() {
        return new ProfilePhotoCollectionRequest(contextPath.addSegment("photos"));
    }

    public ProfilePhotoRequest photos(String id) {
        return new ProfilePhotoRequest(contextPath.addSegment("photos").addKeys(new NameValue(id.toString())));
    }


    public DriveCollectionRequest drives() {
        return new DriveCollectionRequest(contextPath.addSegment("drives"));
    }

    public DriveRequest drives(String id) {
        return new DriveRequest(contextPath.addSegment("drives").addKeys(new NameValue(id.toString())));
    }

    public SiteCollectionRequest followedSites() {
        return new SiteCollectionRequest(contextPath.addSegment("followedSites"));
    }

    public SiteRequest followedSites(String id) {
        return new SiteRequest(contextPath.addSegment("followedSites").addKeys(new NameValue(id.toString())));
    }

    public ExtensionCollectionRequest extensions() {
        return new ExtensionCollectionRequest(contextPath.addSegment("extensions"));
    }

    public ExtensionRequest extensions(String id) {
        return new ExtensionRequest(contextPath.addSegment("extensions").addKeys(new NameValue(id.toString())));
    }

    public ApprovalCollectionRequest approvals() {
        return new ApprovalCollectionRequest(contextPath.addSegment("approvals"));
    }

    public ApprovalRequest approvals(String id) {
        return new ApprovalRequest(contextPath.addSegment("approvals").addKeys(new NameValue(id.toString())));
    }

    public AppConsentRequestCollectionRequest appConsentRequestsForApproval() {
        return new AppConsentRequestCollectionRequest(contextPath.addSegment("appConsentRequestsForApproval"));
    }

    public AppConsentRequestRequest appConsentRequestsForApproval(String id) {
        return new AppConsentRequestRequest(contextPath.addSegment("appConsentRequestsForApproval").addKeys(new NameValue(id.toString())));
    }

    public AccessReviewInstanceCollectionRequest pendingAccessReviewInstances() {
        return new AccessReviewInstanceCollectionRequest(contextPath.addSegment("pendingAccessReviewInstances"));
    }

    public AccessReviewInstanceRequest pendingAccessReviewInstances(String id) {
        return new AccessReviewInstanceRequest(contextPath.addSegment("pendingAccessReviewInstances").addKeys(new NameValue(id.toString())));
    }

    public AgreementAcceptanceCollectionRequest agreementAcceptances() {
        return new AgreementAcceptanceCollectionRequest(contextPath.addSegment("agreementAcceptances"));
    }

    public AgreementAcceptanceRequest agreementAcceptances(String id) {
        return new AgreementAcceptanceRequest(contextPath.addSegment("agreementAcceptances").addKeys(new NameValue(id.toString())));
    }

    public DeviceEnrollmentConfigurationCollectionRequest deviceEnrollmentConfigurations() {
        return new DeviceEnrollmentConfigurationCollectionRequest(contextPath.addSegment("deviceEnrollmentConfigurations"));
    }

    public DeviceEnrollmentConfigurationRequest deviceEnrollmentConfigurations(String id) {
        return new DeviceEnrollmentConfigurationRequest(contextPath.addSegment("deviceEnrollmentConfigurations").addKeys(new NameValue(id.toString())));
    }

    public ManagedDeviceCollectionRequest managedDevices() {
        return new ManagedDeviceCollectionRequest(contextPath.addSegment("managedDevices"));
    }

    public ManagedDeviceRequest managedDevices(String id) {
        return new ManagedDeviceRequest(contextPath.addSegment("managedDevices").addKeys(new NameValue(id.toString())));
    }

    public ManagedAppRegistrationCollectionRequest managedAppRegistrations() {
        return new ManagedAppRegistrationCollectionRequest(contextPath.addSegment("managedAppRegistrations"));
    }

    public ManagedAppRegistrationRequest managedAppRegistrations(String id) {
        return new ManagedAppRegistrationRequest(contextPath.addSegment("managedAppRegistrations").addKeys(new NameValue(id.toString())));
    }

    public WindowsInformationProtectionDeviceRegistrationCollectionRequest windowsInformationProtectionDeviceRegistrations() {
        return new WindowsInformationProtectionDeviceRegistrationCollectionRequest(contextPath.addSegment("windowsInformationProtectionDeviceRegistrations"));
    }

    public WindowsInformationProtectionDeviceRegistrationRequest windowsInformationProtectionDeviceRegistrations(String id) {
        return new WindowsInformationProtectionDeviceRegistrationRequest(contextPath.addSegment("windowsInformationProtectionDeviceRegistrations").addKeys(new NameValue(id.toString())));
    }

    public DeviceManagementTroubleshootingEventCollectionRequest deviceManagementTroubleshootingEvents() {
        return new DeviceManagementTroubleshootingEventCollectionRequest(contextPath.addSegment("deviceManagementTroubleshootingEvents"));
    }

    public DeviceManagementTroubleshootingEventRequest deviceManagementTroubleshootingEvents(String id) {
        return new DeviceManagementTroubleshootingEventRequest(contextPath.addSegment("deviceManagementTroubleshootingEvents").addKeys(new NameValue(id.toString())));
    }

    public MobileAppIntentAndStateCollectionRequest mobileAppIntentAndStates() {
        return new MobileAppIntentAndStateCollectionRequest(contextPath.addSegment("mobileAppIntentAndStates"));
    }

    public MobileAppIntentAndStateRequest mobileAppIntentAndStates(String id) {
        return new MobileAppIntentAndStateRequest(contextPath.addSegment("mobileAppIntentAndStates").addKeys(new NameValue(id.toString())));
    }

    public MobileAppTroubleshootingEventCollectionRequest mobileAppTroubleshootingEvents() {
        return new MobileAppTroubleshootingEventCollectionRequest(contextPath.addSegment("mobileAppTroubleshootingEvents"));
    }

    public MobileAppTroubleshootingEventRequest mobileAppTroubleshootingEvents(String id) {
        return new MobileAppTroubleshootingEventRequest(contextPath.addSegment("mobileAppTroubleshootingEvents").addKeys(new NameValue(id.toString())));
    }

    public NotificationCollectionRequest notifications() {
        return new NotificationCollectionRequest(contextPath.addSegment("notifications"));
    }

    public NotificationRequest notifications(String id) {
        return new NotificationRequest(contextPath.addSegment("notifications").addKeys(new NameValue(id.toString())));
    }






    public UserActivityCollectionRequest activities() {
        return new UserActivityCollectionRequest(contextPath.addSegment("activities"));
    }

    public UserActivityRequest activities(String id) {
        return new UserActivityRequest(contextPath.addSegment("activities").addKeys(new NameValue(id.toString())));
    }

    public DeviceCollectionRequest devices() {
        return new DeviceCollectionRequest(contextPath.addSegment("devices"));
    }

    public DeviceRequest devices(String id) {
        return new DeviceRequest(contextPath.addSegment("devices").addKeys(new NameValue(id.toString())));
    }

    public OnlineMeetingCollectionRequest onlineMeetings() {
        return new OnlineMeetingCollectionRequest(contextPath.addSegment("onlineMeetings"));
    }

    public OnlineMeetingRequest onlineMeetings(String id) {
        return new OnlineMeetingRequest(contextPath.addSegment("onlineMeetings").addKeys(new NameValue(id.toString())));
    }



    public ChatCollectionRequest chats() {
        return new ChatCollectionRequest(contextPath.addSegment("chats"));
    }

    public ChatRequest chats(String id) {
        return new ChatRequest(contextPath.addSegment("chats").addKeys(new NameValue(id.toString())));
    }

    public TeamCollectionRequest joinedTeams() {
        return new TeamCollectionRequest(contextPath.addSegment("joinedTeams"));
    }

    public TeamRequest joinedTeams(String id) {
        return new TeamRequest(contextPath.addSegment("joinedTeams").addKeys(new NameValue(id.toString())));
    }


    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<User> delta() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), User.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getManagedAppBlockedUsers")
    @JsonIgnore
    public CollectionPageNonEntityRequest<String> getManagedAppBlockedUsers() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getManagedAppBlockedUsers"), String.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

}
