package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.UserAppInstallStatus;
import odata.msgraph.client.beta.entity.request.MobileAppInstallStatusRequest;
import odata.msgraph.client.beta.entity.request.UserAppInstallStatusRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class UserAppInstallStatusCollectionRequest extends CollectionPageEntityRequest<UserAppInstallStatus, UserAppInstallStatusRequest>{

    protected ContextPath contextPath;

    public UserAppInstallStatusCollectionRequest(ContextPath contextPath) {
        super(contextPath, UserAppInstallStatus.class, cp -> new UserAppInstallStatusRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }


    public MobileAppInstallStatusCollectionRequest deviceStatuses() {
        return new MobileAppInstallStatusCollectionRequest(contextPath.addSegment("deviceStatuses"));
    }

    public MobileAppInstallStatusRequest deviceStatuses(String id) {
        return new MobileAppInstallStatusRequest(contextPath.addSegment("deviceStatuses").addKeys(new NameValue(id.toString())));
    }

}
