package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.UnifiedRoleAssignmentMultiple;
import odata.msgraph.client.beta.entity.request.AppScopeRequest;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;
import odata.msgraph.client.beta.entity.request.UnifiedRoleAssignmentMultipleRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class UnifiedRoleAssignmentMultipleCollectionRequest extends CollectionPageEntityRequest<UnifiedRoleAssignmentMultiple, UnifiedRoleAssignmentMultipleRequest>{

    protected ContextPath contextPath;

    public UnifiedRoleAssignmentMultipleCollectionRequest(ContextPath contextPath) {
        super(contextPath, UnifiedRoleAssignmentMultiple.class, cp -> new UnifiedRoleAssignmentMultipleRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }


    public DirectoryObjectCollectionRequest principals() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("principals"));
    }

    public DirectoryObjectRequest principals(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("principals").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest directoryScopes() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("directoryScopes"));
    }

    public DirectoryObjectRequest directoryScopes(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("directoryScopes").addKeys(new NameValue(id.toString())));
    }

    public AppScopeCollectionRequest appScopes() {
        return new AppScopeCollectionRequest(contextPath.addSegment("appScopes"));
    }

    public AppScopeRequest appScopes(String id) {
        return new AppScopeRequest(contextPath.addSegment("appScopes").addKeys(new NameValue(id.toString())));
    }

}
