package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.ThreatAssessmentRequest;
import odata.msgraph.client.beta.entity.request.ThreatAssessmentRequestRequest;
import odata.msgraph.client.beta.entity.request.ThreatAssessmentResultRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class ThreatAssessmentRequestCollectionRequest extends CollectionPageEntityRequest<ThreatAssessmentRequest, ThreatAssessmentRequestRequest>{

    protected ContextPath contextPath;

    public ThreatAssessmentRequestCollectionRequest(ContextPath contextPath) {
        super(contextPath, ThreatAssessmentRequest.class, cp -> new ThreatAssessmentRequestRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public ThreatAssessmentResultCollectionRequest results() {
        return new ThreatAssessmentResultCollectionRequest(contextPath.addSegment("results"));
    }

    public ThreatAssessmentResultRequest results(String id) {
        return new ThreatAssessmentResultRequest(contextPath.addSegment("results").addKeys(new NameValue(id.toString())));
    }

}
