package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.TermsAndConditions;
import odata.msgraph.client.beta.entity.request.TermsAndConditionsAcceptanceStatusRequest;
import odata.msgraph.client.beta.entity.request.TermsAndConditionsAssignmentRequest;
import odata.msgraph.client.beta.entity.request.TermsAndConditionsGroupAssignmentRequest;
import odata.msgraph.client.beta.entity.request.TermsAndConditionsRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class TermsAndConditionsCollectionRequest extends CollectionPageEntityRequest<TermsAndConditions, TermsAndConditionsRequest>{

    protected ContextPath contextPath;

    public TermsAndConditionsCollectionRequest(ContextPath contextPath) {
        super(contextPath, TermsAndConditions.class, cp -> new TermsAndConditionsRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public TermsAndConditionsGroupAssignmentCollectionRequest groupAssignments() {
        return new TermsAndConditionsGroupAssignmentCollectionRequest(contextPath.addSegment("groupAssignments"));
    }

    public TermsAndConditionsGroupAssignmentRequest groupAssignments(String id) {
        return new TermsAndConditionsGroupAssignmentRequest(contextPath.addSegment("groupAssignments").addKeys(new NameValue(id.toString())));
    }

    public TermsAndConditionsAssignmentCollectionRequest assignments() {
        return new TermsAndConditionsAssignmentCollectionRequest(contextPath.addSegment("assignments"));
    }

    public TermsAndConditionsAssignmentRequest assignments(String id) {
        return new TermsAndConditionsAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }

    public TermsAndConditionsAcceptanceStatusCollectionRequest acceptanceStatuses() {
        return new TermsAndConditionsAcceptanceStatusCollectionRequest(contextPath.addSegment("acceptanceStatuses"));
    }

    public TermsAndConditionsAcceptanceStatusRequest acceptanceStatuses(String id) {
        return new TermsAndConditionsAcceptanceStatusRequest(contextPath.addSegment("acceptanceStatuses").addKeys(new NameValue(id.toString())));
    }

}
