package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.TeamsApp;
import odata.msgraph.client.beta.entity.request.TeamsAppDefinitionRequest;
import odata.msgraph.client.beta.entity.request.TeamsAppRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class TeamsAppCollectionRequest extends CollectionPageEntityRequest<TeamsApp, TeamsAppRequest>{

    protected ContextPath contextPath;

    public TeamsAppCollectionRequest(ContextPath contextPath) {
        super(contextPath, TeamsApp.class, cp -> new TeamsAppRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public TeamsAppDefinitionCollectionRequest appDefinitions() {
        return new TeamsAppDefinitionCollectionRequest(contextPath.addSegment("appDefinitions"));
    }

    public TeamsAppDefinitionRequest appDefinitions(String id) {
        return new TeamsAppDefinitionRequest(contextPath.addSegment("appDefinitions").addKeys(new NameValue(id.toString())));
    }

}
