package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.ChatMessage;
import odata.msgraph.client.beta.entity.Team;
import odata.msgraph.client.beta.entity.request.ChannelRequest;
import odata.msgraph.client.beta.entity.request.ConversationMemberRequest;
import odata.msgraph.client.beta.entity.request.TeamRequest;
import odata.msgraph.client.beta.entity.request.TeamsAppInstallationRequest;
import odata.msgraph.client.beta.entity.request.TeamsAsyncOperationRequest;
import odata.msgraph.client.beta.entity.request.UserRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class TeamCollectionRequest extends CollectionPageEntityRequest<Team, TeamRequest>{

    protected ContextPath contextPath;

    public TeamCollectionRequest(ContextPath contextPath) {
        super(contextPath, Team.class, cp -> new TeamRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }





    public UserCollectionRequest owners() {
        return new UserCollectionRequest(contextPath.addSegment("owners"));
    }

    public UserRequest owners(String id) {
        return new UserRequest(contextPath.addSegment("owners").addKeys(new NameValue(id.toString())));
    }

    public ConversationMemberCollectionRequest members() {
        return new ConversationMemberCollectionRequest(contextPath.addSegment("members"));
    }

    public ConversationMemberRequest members(String id) {
        return new ConversationMemberRequest(contextPath.addSegment("members").addKeys(new NameValue(id.toString())));
    }

    public ChannelCollectionRequest channels() {
        return new ChannelCollectionRequest(contextPath.addSegment("channels"));
    }

    public ChannelRequest channels(String id) {
        return new ChannelRequest(contextPath.addSegment("channels").addKeys(new NameValue(id.toString())));
    }


    public TeamsAppInstallationCollectionRequest installedApps() {
        return new TeamsAppInstallationCollectionRequest(contextPath.addSegment("installedApps"));
    }

    public TeamsAppInstallationRequest installedApps(String id) {
        return new TeamsAppInstallationRequest(contextPath.addSegment("installedApps").addKeys(new NameValue(id.toString())));
    }

    public TeamsAsyncOperationCollectionRequest operations() {
        return new TeamsAsyncOperationCollectionRequest(contextPath.addSegment("operations"));
    }

    public TeamsAsyncOperationRequest operations(String id) {
        return new TeamsAsyncOperationRequest(contextPath.addSegment("operations").addKeys(new NameValue(id.toString())));
    }

    @Function(name = "allMessages")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ChatMessage> allMessages() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.allMessages"), ChatMessage.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
