package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.complex.SynchronizationSecretKeyStringValuePair;
import odata.msgraph.client.beta.entity.SynchronizationJob;
import odata.msgraph.client.beta.entity.request.SynchronizationJobRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class SynchronizationJobCollectionRequest extends CollectionPageEntityRequest<SynchronizationJob, SynchronizationJobRequest>{

    protected ContextPath contextPath;

    public SynchronizationJobCollectionRequest(ContextPath contextPath) {
        super(contextPath, SynchronizationJob.class, cp -> new SynchronizationJobRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }


    @Action(name = "validateCredentials")
    @JsonIgnore
    public ActionRequestNoReturn validateCredentials(String applicationIdentifier, String templateId, Boolean useSavedCredentials, List<SynchronizationSecretKeyStringValuePair> credentials) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("applicationIdentifier", "Edm.String", Checks.checkIsAscii(applicationIdentifier))
            .put("templateId", "Edm.String", Checks.checkIsAscii(templateId))
            .put("useSavedCredentials", "Edm.Boolean", useSavedCredentials)
            .put("credentials", "Collection(microsoft.graph.synchronizationSecretKeyStringValuePair)", credentials)
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.validateCredentials"), _parameters);
    }

}
