package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.entity.Site;
import odata.msgraph.client.beta.entity.request.BaseItemRequest;
import odata.msgraph.client.beta.entity.request.ColumnDefinitionRequest;
import odata.msgraph.client.beta.entity.request.ContentTypeRequest;
import odata.msgraph.client.beta.entity.request.DriveRequest;
import odata.msgraph.client.beta.entity.request.ListRequest;
import odata.msgraph.client.beta.entity.request.SitePageRequest;
import odata.msgraph.client.beta.entity.request.SiteRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class SiteCollectionRequest extends CollectionPageEntityRequest<Site, SiteRequest>{

    protected ContextPath contextPath;

    public SiteCollectionRequest(ContextPath contextPath) {
        super(contextPath, Site.class, cp -> new SiteRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }


    public ColumnDefinitionCollectionRequest columns() {
        return new ColumnDefinitionCollectionRequest(contextPath.addSegment("columns"));
    }

    public ColumnDefinitionRequest columns(String id) {
        return new ColumnDefinitionRequest(contextPath.addSegment("columns").addKeys(new NameValue(id.toString())));
    }

    public ContentTypeCollectionRequest contentTypes() {
        return new ContentTypeCollectionRequest(contextPath.addSegment("contentTypes"));
    }

    public ContentTypeRequest contentTypes(String id) {
        return new ContentTypeRequest(contextPath.addSegment("contentTypes").addKeys(new NameValue(id.toString())));
    }


    public DriveCollectionRequest drives() {
        return new DriveCollectionRequest(contextPath.addSegment("drives"));
    }

    public DriveRequest drives(String id) {
        return new DriveRequest(contextPath.addSegment("drives").addKeys(new NameValue(id.toString())));
    }

    public BaseItemCollectionRequest items() {
        return new BaseItemCollectionRequest(contextPath.addSegment("items"));
    }

    public BaseItemRequest items(String id) {
        return new BaseItemRequest(contextPath.addSegment("items").addKeys(new NameValue(id.toString())));
    }

    public ListCollectionRequest lists() {
        return new ListCollectionRequest(contextPath.addSegment("lists"));
    }

    public ListRequest lists(String id) {
        return new ListRequest(contextPath.addSegment("lists").addKeys(new NameValue(id.toString())));
    }

    public SitePageCollectionRequest pages() {
        return new SitePageCollectionRequest(contextPath.addSegment("pages"));
    }

    public SitePageRequest pages(String id) {
        return new SitePageRequest(contextPath.addSegment("pages").addKeys(new NameValue(id.toString())));
    }

    public SiteCollectionRequest sites() {
        return new SiteCollectionRequest(contextPath.addSegment("sites"));
    }

    public SiteRequest sites(String id) {
        return new SiteRequest(contextPath.addSegment("sites").addKeys(new NameValue(id.toString())));
    }


    @Action(name = "add")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Site> add(List<Site> value) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("value", "Collection(microsoft.graph.site)", value)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.add"), Site.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Action(name = "remove")
    @JsonIgnore
    public CollectionPageNonEntityRequest<Site> remove(List<Site> value) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("value", "Collection(microsoft.graph.site)", value)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.remove"), Site.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
