package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.SharedDriveItem;
import odata.msgraph.client.beta.entity.request.DriveItemRequest;
import odata.msgraph.client.beta.entity.request.SharedDriveItemRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class SharedDriveItemCollectionRequest extends CollectionPageEntityRequest<SharedDriveItem, SharedDriveItemRequest>{

    protected ContextPath contextPath;

    public SharedDriveItemCollectionRequest(ContextPath contextPath) {
        super(contextPath, SharedDriveItem.class, cp -> new SharedDriveItemRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }


    public DriveItemCollectionRequest items() {
        return new DriveItemCollectionRequest(contextPath.addSegment("items"));
    }

    public DriveItemRequest items(String id) {
        return new DriveItemRequest(contextPath.addSegment("items").addKeys(new NameValue(id.toString())));
    }






}
