package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.ServicePrincipal;
import odata.msgraph.client.beta.entity.request.AppRoleAssignmentRequest;
import odata.msgraph.client.beta.entity.request.ClaimsMappingPolicyRequest;
import odata.msgraph.client.beta.entity.request.DirectoryObjectRequest;
import odata.msgraph.client.beta.entity.request.EndpointRequest;
import odata.msgraph.client.beta.entity.request.HomeRealmDiscoveryPolicyRequest;
import odata.msgraph.client.beta.entity.request.LicenseDetailsRequest;
import odata.msgraph.client.beta.entity.request.OAuth2PermissionGrantRequest;
import odata.msgraph.client.beta.entity.request.ServicePrincipalRequest;
import odata.msgraph.client.beta.entity.request.TokenIssuancePolicyRequest;
import odata.msgraph.client.beta.entity.request.TokenLifetimePolicyRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class ServicePrincipalCollectionRequest extends CollectionPageEntityRequest<ServicePrincipal, ServicePrincipalRequest>{

    protected ContextPath contextPath;

    public ServicePrincipalCollectionRequest(ContextPath contextPath) {
        super(contextPath, ServicePrincipal.class, cp -> new ServicePrincipalRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public AppRoleAssignmentCollectionRequest appRoleAssignedTo() {
        return new AppRoleAssignmentCollectionRequest(contextPath.addSegment("appRoleAssignedTo"));
    }

    public AppRoleAssignmentRequest appRoleAssignedTo(String id) {
        return new AppRoleAssignmentRequest(contextPath.addSegment("appRoleAssignedTo").addKeys(new NameValue(id.toString())));
    }

    public AppRoleAssignmentCollectionRequest appRoleAssignments() {
        return new AppRoleAssignmentCollectionRequest(contextPath.addSegment("appRoleAssignments"));
    }

    public AppRoleAssignmentRequest appRoleAssignments(String id) {
        return new AppRoleAssignmentRequest(contextPath.addSegment("appRoleAssignments").addKeys(new NameValue(id.toString())));
    }

    public ClaimsMappingPolicyCollectionRequest claimsMappingPolicies() {
        return new ClaimsMappingPolicyCollectionRequest(contextPath.addSegment("claimsMappingPolicies"));
    }

    public ClaimsMappingPolicyRequest claimsMappingPolicies(String id) {
        return new ClaimsMappingPolicyRequest(contextPath.addSegment("claimsMappingPolicies").addKeys(new NameValue(id.toString())));
    }

    public HomeRealmDiscoveryPolicyCollectionRequest homeRealmDiscoveryPolicies() {
        return new HomeRealmDiscoveryPolicyCollectionRequest(contextPath.addSegment("homeRealmDiscoveryPolicies"));
    }

    public HomeRealmDiscoveryPolicyRequest homeRealmDiscoveryPolicies(String id) {
        return new HomeRealmDiscoveryPolicyRequest(contextPath.addSegment("homeRealmDiscoveryPolicies").addKeys(new NameValue(id.toString())));
    }

    public EndpointCollectionRequest endpoints() {
        return new EndpointCollectionRequest(contextPath.addSegment("endpoints"));
    }

    public EndpointRequest endpoints(String id) {
        return new EndpointRequest(contextPath.addSegment("endpoints").addKeys(new NameValue(id.toString())));
    }

    public OAuth2PermissionGrantCollectionRequest oauth2PermissionGrants() {
        return new OAuth2PermissionGrantCollectionRequest(contextPath.addSegment("oauth2PermissionGrants"));
    }

    public OAuth2PermissionGrantRequest oauth2PermissionGrants(String id) {
        return new OAuth2PermissionGrantRequest(contextPath.addSegment("oauth2PermissionGrants").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest memberOf() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("memberOf"));
    }

    public DirectoryObjectRequest memberOf(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("memberOf").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest transitiveMemberOf() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("transitiveMemberOf"));
    }

    public DirectoryObjectRequest transitiveMemberOf(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("transitiveMemberOf").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest createdObjects() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("createdObjects"));
    }

    public DirectoryObjectRequest createdObjects(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("createdObjects").addKeys(new NameValue(id.toString())));
    }

    public LicenseDetailsCollectionRequest licenseDetails() {
        return new LicenseDetailsCollectionRequest(contextPath.addSegment("licenseDetails"));
    }

    public LicenseDetailsRequest licenseDetails(String id) {
        return new LicenseDetailsRequest(contextPath.addSegment("licenseDetails").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest owners() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("owners"));
    }

    public DirectoryObjectRequest owners(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("owners").addKeys(new NameValue(id.toString())));
    }

    public DirectoryObjectCollectionRequest ownedObjects() {
        return new DirectoryObjectCollectionRequest(contextPath.addSegment("ownedObjects"));
    }

    public DirectoryObjectRequest ownedObjects(String id) {
        return new DirectoryObjectRequest(contextPath.addSegment("ownedObjects").addKeys(new NameValue(id.toString())));
    }

    public TokenIssuancePolicyCollectionRequest tokenIssuancePolicies() {
        return new TokenIssuancePolicyCollectionRequest(contextPath.addSegment("tokenIssuancePolicies"));
    }

    public TokenIssuancePolicyRequest tokenIssuancePolicies(String id) {
        return new TokenIssuancePolicyRequest(contextPath.addSegment("tokenIssuancePolicies").addKeys(new NameValue(id.toString())));
    }

    public TokenLifetimePolicyCollectionRequest tokenLifetimePolicies() {
        return new TokenLifetimePolicyCollectionRequest(contextPath.addSegment("tokenLifetimePolicies"));
    }

    public TokenLifetimePolicyRequest tokenLifetimePolicies(String id) {
        return new TokenLifetimePolicyRequest(contextPath.addSegment("tokenLifetimePolicies").addKeys(new NameValue(id.toString())));
    }


    @Function(name = "delta")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ServicePrincipal> delta() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.delta"), ServicePrincipal.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
