package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.ActionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.complex.CurrentLabel;
import odata.msgraph.client.beta.complex.DiscoveredSensitiveType;
import odata.msgraph.client.beta.entity.EvaluateLabelJobResponse;
import odata.msgraph.client.beta.entity.SensitivityLabel;
import odata.msgraph.client.beta.entity.request.SensitivityLabelRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class SensitivityLabelCollectionRequest extends CollectionPageEntityRequest<SensitivityLabel, SensitivityLabelRequest>{

    protected ContextPath contextPath;

    public SensitivityLabelCollectionRequest(ContextPath contextPath) {
        super(contextPath, SensitivityLabel.class, cp -> new SensitivityLabelRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public SensitivityLabelCollectionRequest sublabels() {
        return new SensitivityLabelCollectionRequest(contextPath.addSegment("sublabels"));
    }

    public SensitivityLabelRequest sublabels(String id) {
        return new SensitivityLabelRequest(contextPath.addSegment("sublabels").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "evaluate")
    @JsonIgnore
    public ActionRequestReturningNonCollectionUnwrapped<EvaluateLabelJobResponse> evaluate(List<DiscoveredSensitiveType> discoveredSensitiveTypes, CurrentLabel currentLabel) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("discoveredSensitiveTypes", "Collection(microsoft.graph.discoveredSensitiveType)", discoveredSensitiveTypes)
            .put("currentLabel", "microsoft.graph.currentLabel", currentLabel)
            .build();
        return new ActionRequestReturningNonCollectionUnwrapped<EvaluateLabelJobResponse>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.evaluate"), EvaluateLabelJobResponse.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
