package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.SecurityBaselineState;
import odata.msgraph.client.beta.entity.request.SecurityBaselineSettingStateRequest;
import odata.msgraph.client.beta.entity.request.SecurityBaselineStateRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class SecurityBaselineStateCollectionRequest extends CollectionPageEntityRequest<SecurityBaselineState, SecurityBaselineStateRequest>{

    protected ContextPath contextPath;

    public SecurityBaselineStateCollectionRequest(ContextPath contextPath) {
        super(contextPath, SecurityBaselineState.class, cp -> new SecurityBaselineStateRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public SecurityBaselineSettingStateCollectionRequest settingStates() {
        return new SecurityBaselineSettingStateCollectionRequest(contextPath.addSegment("settingStates"));
    }

    public SecurityBaselineSettingStateRequest settingStates(String id) {
        return new SecurityBaselineSettingStateRequest(contextPath.addSegment("settingStates").addKeys(new NameValue(id.toString())));
    }

}
