package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.SectionGroup;
import odata.msgraph.client.beta.entity.request.OnenoteSectionRequest;
import odata.msgraph.client.beta.entity.request.SectionGroupRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class SectionGroupCollectionRequest extends CollectionPageEntityRequest<SectionGroup, SectionGroupRequest>{

    protected ContextPath contextPath;

    public SectionGroupCollectionRequest(ContextPath contextPath) {
        super(contextPath, SectionGroup.class, cp -> new SectionGroupRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }



    public OnenoteSectionCollectionRequest sections() {
        return new OnenoteSectionCollectionRequest(contextPath.addSegment("sections"));
    }

    public OnenoteSectionRequest sections(String id) {
        return new OnenoteSectionRequest(contextPath.addSegment("sections").addKeys(new NameValue(id.toString())));
    }

    public SectionGroupCollectionRequest sectionGroups() {
        return new SectionGroupCollectionRequest(contextPath.addSegment("sectionGroups"));
    }

    public SectionGroupRequest sectionGroups(String id) {
        return new SectionGroupRequest(contextPath.addSegment("sectionGroups").addKeys(new NameValue(id.toString())));
    }

}
