package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.SalesQuote;
import odata.msgraph.client.beta.entity.request.SalesQuoteLineRequest;
import odata.msgraph.client.beta.entity.request.SalesQuoteRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class SalesQuoteCollectionRequest extends CollectionPageEntityRequest<SalesQuote, SalesQuoteRequest>{

    protected ContextPath contextPath;

    public SalesQuoteCollectionRequest(ContextPath contextPath) {
        super(contextPath, SalesQuote.class, cp -> new SalesQuoteRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public SalesQuoteLineCollectionRequest salesQuoteLines() {
        return new SalesQuoteLineCollectionRequest(contextPath.addSegment("salesQuoteLines"));
    }

    public SalesQuoteLineRequest salesQuoteLines(String id) {
        return new SalesQuoteLineRequest(contextPath.addSegment("salesQuoteLines").addKeys(new NameValue(id.toString())));
    }





}
