package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.SalesOrder;
import odata.msgraph.client.beta.entity.request.SalesOrderLineRequest;
import odata.msgraph.client.beta.entity.request.SalesOrderRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class SalesOrderCollectionRequest extends CollectionPageEntityRequest<SalesOrder, SalesOrderRequest>{

    protected ContextPath contextPath;

    public SalesOrderCollectionRequest(ContextPath contextPath) {
        super(contextPath, SalesOrder.class, cp -> new SalesOrderRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public SalesOrderLineCollectionRequest salesOrderLines() {
        return new SalesOrderLineCollectionRequest(contextPath.addSegment("salesOrderLines"));
    }

    public SalesOrderLineRequest salesOrderLines(String id) {
        return new SalesOrderLineRequest(contextPath.addSegment("salesOrderLines").addKeys(new NameValue(id.toString())));
    }




}
