package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.SalesInvoice;
import odata.msgraph.client.beta.entity.request.SalesInvoiceLineRequest;
import odata.msgraph.client.beta.entity.request.SalesInvoiceRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class SalesInvoiceCollectionRequest extends CollectionPageEntityRequest<SalesInvoice, SalesInvoiceRequest>{

    protected ContextPath contextPath;

    public SalesInvoiceCollectionRequest(ContextPath contextPath) {
        super(contextPath, SalesInvoice.class, cp -> new SalesInvoiceRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public SalesInvoiceLineCollectionRequest salesInvoiceLines() {
        return new SalesInvoiceLineCollectionRequest(contextPath.addSegment("salesInvoiceLines"));
    }

    public SalesInvoiceLineRequest salesInvoiceLines(String id) {
        return new SalesInvoiceLineRequest(contextPath.addSegment("salesInvoiceLines").addKeys(new NameValue(id.toString())));
    }





}
