package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.SalesCreditMemo;
import odata.msgraph.client.beta.entity.request.SalesCreditMemoLineRequest;
import odata.msgraph.client.beta.entity.request.SalesCreditMemoRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class SalesCreditMemoCollectionRequest extends CollectionPageEntityRequest<SalesCreditMemo, SalesCreditMemoRequest>{

    protected ContextPath contextPath;

    public SalesCreditMemoCollectionRequest(ContextPath contextPath) {
        super(contextPath, SalesCreditMemo.class, cp -> new SalesCreditMemoRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public SalesCreditMemoLineCollectionRequest salesCreditMemoLines() {
        return new SalesCreditMemoLineCollectionRequest(contextPath.addSegment("salesCreditMemoLines"));
    }

    public SalesCreditMemoLineRequest salesCreditMemoLines(String id) {
        return new SalesCreditMemoLineRequest(contextPath.addSegment("salesCreditMemoLines").addKeys(new NameValue(id.toString())));
    }




}
