package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollection;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.entity.RoleScopeTag;
import odata.msgraph.client.beta.entity.request.RoleScopeTagAutoAssignmentRequest;
import odata.msgraph.client.beta.entity.request.RoleScopeTagRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class RoleScopeTagCollectionRequest extends CollectionPageEntityRequest<RoleScopeTag, RoleScopeTagRequest>{

    protected ContextPath contextPath;

    public RoleScopeTagCollectionRequest(ContextPath contextPath) {
        super(contextPath, RoleScopeTag.class, cp -> new RoleScopeTagRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public RoleScopeTagAutoAssignmentCollectionRequest assignments() {
        return new RoleScopeTagAutoAssignmentCollectionRequest(contextPath.addSegment("assignments"));
    }

    public RoleScopeTagAutoAssignmentRequest assignments(String id) {
        return new RoleScopeTagAutoAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "getRoleScopeTagsById")
    @JsonIgnore
    public CollectionPageNonEntityRequest<RoleScopeTag> getRoleScopeTagsById(List<String> roleScopeTagIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("roleScopeTagIds", "Collection(Edm.String)", Checks.checkIsAscii(roleScopeTagIds))
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getRoleScopeTagsById"), RoleScopeTag.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "hasCustomRoleScopeTag")
    @JsonIgnore
    public FunctionRequestReturningNonCollection<Boolean> hasCustomRoleScopeTag() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return new FunctionRequestReturningNonCollection<Boolean>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.hasCustomRoleScopeTag"), Boolean.class, _parameters, com.github.davidmoten.odata.client.internal.EdmSchemaInfo.INSTANCE);
    }

}
