package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.RoleDefinition;
import odata.msgraph.client.beta.entity.request.RoleAssignmentRequest;
import odata.msgraph.client.beta.entity.request.RoleDefinitionRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class RoleDefinitionCollectionRequest extends CollectionPageEntityRequest<RoleDefinition, RoleDefinitionRequest>{

    protected ContextPath contextPath;

    public RoleDefinitionCollectionRequest(ContextPath contextPath) {
        super(contextPath, RoleDefinition.class, cp -> new RoleDefinitionRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public RoleAssignmentCollectionRequest roleAssignments() {
        return new RoleAssignmentCollectionRequest(contextPath.addSegment("roleAssignments"));
    }

    public RoleAssignmentRequest roleAssignments(String id) {
        return new RoleAssignmentRequest(contextPath.addSegment("roleAssignments").addKeys(new NameValue(id.toString())));
    }

}
