package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.ActionRequestNoReturn;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Action;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.List;
import java.util.Map;

import odata.msgraph.client.beta.entity.RiskyUser;
import odata.msgraph.client.beta.entity.request.RiskyUserHistoryItemRequest;
import odata.msgraph.client.beta.entity.request.RiskyUserRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class RiskyUserCollectionRequest extends CollectionPageEntityRequest<RiskyUser, RiskyUserRequest>{

    protected ContextPath contextPath;

    public RiskyUserCollectionRequest(ContextPath contextPath) {
        super(contextPath, RiskyUser.class, cp -> new RiskyUserRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public RiskyUserHistoryItemCollectionRequest history() {
        return new RiskyUserHistoryItemCollectionRequest(contextPath.addSegment("history"));
    }

    public RiskyUserHistoryItemRequest history(String id) {
        return new RiskyUserHistoryItemRequest(contextPath.addSegment("history").addKeys(new NameValue(id.toString())));
    }

    @Action(name = "dismiss")
    @JsonIgnore
    public ActionRequestNoReturn dismiss(List<String> userIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("userIds", "Collection(Edm.String)", Checks.checkIsAscii(userIds))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.dismiss"), _parameters);
    }

    @Action(name = "confirmCompromised")
    @JsonIgnore
    public ActionRequestNoReturn confirmCompromised(List<String> userIds) {
        Map<String, TypedObject> _parameters = ParameterMap
            .put("userIds", "Collection(Edm.String)", Checks.checkIsAscii(userIds))
            .build();
        return new ActionRequestNoReturn(this.contextPath.addActionOrFunctionSegment("microsoft.graph.confirmCompromised"), _parameters);
    }

}
