package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.ReviewSet;
import odata.msgraph.client.beta.entity.request.ReviewSetQueryRequest;
import odata.msgraph.client.beta.entity.request.ReviewSetRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class ReviewSetCollectionRequest extends CollectionPageEntityRequest<ReviewSet, ReviewSetRequest>{

    protected ContextPath contextPath;

    public ReviewSetCollectionRequest(ContextPath contextPath) {
        super(contextPath, ReviewSet.class, cp -> new ReviewSetRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public ReviewSetQueryCollectionRequest queries() {
        return new ReviewSetQueryCollectionRequest(contextPath.addSegment("queries"));
    }

    public ReviewSetQueryRequest queries(String id) {
        return new ReviewSetQueryRequest(contextPath.addSegment("queries").addKeys(new NameValue(id.toString())));
    }

}
