package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.FunctionRequestReturningNonCollectionUnwrapped;
import com.github.davidmoten.odata.client.NameValue;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.time.OffsetDateTime;
import java.util.Map;

import odata.msgraph.client.beta.complex.ArchivedPrintJob;
import odata.msgraph.client.beta.complex.GroupPrintUsageSummary;
import odata.msgraph.client.beta.complex.OverallPrintUsageSummary;
import odata.msgraph.client.beta.complex.PrintUsageSummary;
import odata.msgraph.client.beta.complex.PrinterUsageSummary;
import odata.msgraph.client.beta.complex.UserPrintUsageSummary;
import odata.msgraph.client.beta.entity.ReportRoot;
import odata.msgraph.client.beta.entity.request.ApplicationSignInDetailedSummaryRequest;
import odata.msgraph.client.beta.entity.request.CredentialUserRegistrationDetailsRequest;
import odata.msgraph.client.beta.entity.request.PrintUsageSummaryByPrinterRequest;
import odata.msgraph.client.beta.entity.request.PrintUsageSummaryByUserRequest;
import odata.msgraph.client.beta.entity.request.ReportRootRequest;
import odata.msgraph.client.beta.entity.request.UserCredentialUsageDetailsRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class ReportRootCollectionRequest extends CollectionPageEntityRequest<ReportRoot, ReportRootRequest>{

    protected ContextPath contextPath;

    public ReportRootCollectionRequest(ContextPath contextPath) {
        super(contextPath, ReportRoot.class, cp -> new ReportRootRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public ApplicationSignInDetailedSummaryCollectionRequest applicationSignInDetailedSummary() {
        return new ApplicationSignInDetailedSummaryCollectionRequest(contextPath.addSegment("applicationSignInDetailedSummary"));
    }

    public ApplicationSignInDetailedSummaryRequest applicationSignInDetailedSummary(String id) {
        return new ApplicationSignInDetailedSummaryRequest(contextPath.addSegment("applicationSignInDetailedSummary").addKeys(new NameValue(id.toString())));
    }

    public CredentialUserRegistrationDetailsCollectionRequest credentialUserRegistrationDetails() {
        return new CredentialUserRegistrationDetailsCollectionRequest(contextPath.addSegment("credentialUserRegistrationDetails"));
    }

    public CredentialUserRegistrationDetailsRequest credentialUserRegistrationDetails(String id) {
        return new CredentialUserRegistrationDetailsRequest(contextPath.addSegment("credentialUserRegistrationDetails").addKeys(new NameValue(id.toString())));
    }

    public UserCredentialUsageDetailsCollectionRequest userCredentialUsageDetails() {
        return new UserCredentialUsageDetailsCollectionRequest(contextPath.addSegment("userCredentialUsageDetails"));
    }

    public UserCredentialUsageDetailsRequest userCredentialUsageDetails(String id) {
        return new UserCredentialUsageDetailsRequest(contextPath.addSegment("userCredentialUsageDetails").addKeys(new NameValue(id.toString())));
    }

    public PrintUsageSummaryByUserCollectionRequest dailyPrintUsageSummariesByUser() {
        return new PrintUsageSummaryByUserCollectionRequest(contextPath.addSegment("dailyPrintUsageSummariesByUser"));
    }

    public PrintUsageSummaryByUserRequest dailyPrintUsageSummariesByUser(String id) {
        return new PrintUsageSummaryByUserRequest(contextPath.addSegment("dailyPrintUsageSummariesByUser").addKeys(new NameValue(id.toString())));
    }

    public PrintUsageSummaryByUserCollectionRequest monthlyPrintUsageSummariesByUser() {
        return new PrintUsageSummaryByUserCollectionRequest(contextPath.addSegment("monthlyPrintUsageSummariesByUser"));
    }

    public PrintUsageSummaryByUserRequest monthlyPrintUsageSummariesByUser(String id) {
        return new PrintUsageSummaryByUserRequest(contextPath.addSegment("monthlyPrintUsageSummariesByUser").addKeys(new NameValue(id.toString())));
    }

    public PrintUsageSummaryByPrinterCollectionRequest dailyPrintUsageSummariesByPrinter() {
        return new PrintUsageSummaryByPrinterCollectionRequest(contextPath.addSegment("dailyPrintUsageSummariesByPrinter"));
    }

    public PrintUsageSummaryByPrinterRequest dailyPrintUsageSummariesByPrinter(String id) {
        return new PrintUsageSummaryByPrinterRequest(contextPath.addSegment("dailyPrintUsageSummariesByPrinter").addKeys(new NameValue(id.toString())));
    }

    public PrintUsageSummaryByPrinterCollectionRequest monthlyPrintUsageSummariesByPrinter() {
        return new PrintUsageSummaryByPrinterCollectionRequest(contextPath.addSegment("monthlyPrintUsageSummariesByPrinter"));
    }

    public PrintUsageSummaryByPrinterRequest monthlyPrintUsageSummariesByPrinter(String id) {
        return new PrintUsageSummaryByPrinterRequest(contextPath.addSegment("monthlyPrintUsageSummariesByPrinter").addKeys(new NameValue(id.toString())));
    }

    @Function(name = "getUserArchivedPrintJobs")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ArchivedPrintJob> getUserArchivedPrintJobs(String userId, OffsetDateTime periodStart, OffsetDateTime periodEnd) {
        Preconditions.checkNotNull(userId, "userId cannot be null");
        Preconditions.checkNotNull(periodStart, "periodStart cannot be null");
        Preconditions.checkNotNull(periodEnd, "periodEnd cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("userId", "Edm.String", Checks.checkIsAscii(userId))
            .put("periodStart", "Edm.DateTimeOffset", periodStart)
            .put("periodEnd", "Edm.DateTimeOffset", periodEnd)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getUserArchivedPrintJobs"), ArchivedPrintJob.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getGroupArchivedPrintJobs")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ArchivedPrintJob> getGroupArchivedPrintJobs(String groupId, OffsetDateTime periodStart, OffsetDateTime periodEnd) {
        Preconditions.checkNotNull(groupId, "groupId cannot be null");
        Preconditions.checkNotNull(periodStart, "periodStart cannot be null");
        Preconditions.checkNotNull(periodEnd, "periodEnd cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("groupId", "Edm.String", Checks.checkIsAscii(groupId))
            .put("periodStart", "Edm.DateTimeOffset", periodStart)
            .put("periodEnd", "Edm.DateTimeOffset", periodEnd)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getGroupArchivedPrintJobs"), ArchivedPrintJob.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getPrinterArchivedPrintJobs")
    @JsonIgnore
    public CollectionPageNonEntityRequest<ArchivedPrintJob> getPrinterArchivedPrintJobs(String printerId, OffsetDateTime periodStart, OffsetDateTime periodEnd) {
        Preconditions.checkNotNull(printerId, "printerId cannot be null");
        Preconditions.checkNotNull(periodStart, "periodStart cannot be null");
        Preconditions.checkNotNull(periodEnd, "periodEnd cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("printerId", "Edm.String", Checks.checkIsAscii(printerId))
            .put("periodStart", "Edm.DateTimeOffset", periodStart)
            .put("periodEnd", "Edm.DateTimeOffset", periodEnd)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getPrinterArchivedPrintJobs"), ArchivedPrintJob.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getUserPrintUsageSummary")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<UserPrintUsageSummary> getUserPrintUsageSummary(String userId, OffsetDateTime periodStart, OffsetDateTime periodEnd) {
        Preconditions.checkNotNull(userId, "userId cannot be null");
        Preconditions.checkNotNull(periodStart, "periodStart cannot be null");
        Preconditions.checkNotNull(periodEnd, "periodEnd cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("userId", "Edm.String", Checks.checkIsAscii(userId))
            .put("periodStart", "Edm.DateTimeOffset", periodStart)
            .put("periodEnd", "Edm.DateTimeOffset", periodEnd)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<UserPrintUsageSummary>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getUserPrintUsageSummary"), UserPrintUsageSummary.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getGroupPrintUsageSummary")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<GroupPrintUsageSummary> getGroupPrintUsageSummary(String groupId, OffsetDateTime periodStart, OffsetDateTime periodEnd) {
        Preconditions.checkNotNull(groupId, "groupId cannot be null");
        Preconditions.checkNotNull(periodStart, "periodStart cannot be null");
        Preconditions.checkNotNull(periodEnd, "periodEnd cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("groupId", "Edm.String", Checks.checkIsAscii(groupId))
            .put("periodStart", "Edm.DateTimeOffset", periodStart)
            .put("periodEnd", "Edm.DateTimeOffset", periodEnd)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<GroupPrintUsageSummary>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getGroupPrintUsageSummary"), GroupPrintUsageSummary.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getPrinterUsageSummary")
    @JsonIgnore
    public FunctionRequestReturningNonCollectionUnwrapped<PrinterUsageSummary> getPrinterUsageSummary(String printerId, OffsetDateTime periodStart, OffsetDateTime periodEnd) {
        Preconditions.checkNotNull(printerId, "printerId cannot be null");
        Preconditions.checkNotNull(periodStart, "periodStart cannot be null");
        Preconditions.checkNotNull(periodEnd, "periodEnd cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("printerId", "Edm.String", Checks.checkIsAscii(printerId))
            .put("periodStart", "Edm.DateTimeOffset", periodStart)
            .put("periodEnd", "Edm.DateTimeOffset", periodEnd)
            .build();
        return new FunctionRequestReturningNonCollectionUnwrapped<PrinterUsageSummary>(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getPrinterUsageSummary"), PrinterUsageSummary.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getPrintUsageSummariesByUser")
    @JsonIgnore
    public CollectionPageNonEntityRequest<UserPrintUsageSummary> getPrintUsageSummariesByUser(OffsetDateTime periodStart, OffsetDateTime periodEnd) {
        Preconditions.checkNotNull(periodStart, "periodStart cannot be null");
        Preconditions.checkNotNull(periodEnd, "periodEnd cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("periodStart", "Edm.DateTimeOffset", periodStart)
            .put("periodEnd", "Edm.DateTimeOffset", periodEnd)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getPrintUsageSummariesByUser"), UserPrintUsageSummary.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getPrintUsageSummariesByGroup")
    @JsonIgnore
    public CollectionPageNonEntityRequest<GroupPrintUsageSummary> getPrintUsageSummariesByGroup(OffsetDateTime periodStart, OffsetDateTime periodEnd) {
        Preconditions.checkNotNull(periodStart, "periodStart cannot be null");
        Preconditions.checkNotNull(periodEnd, "periodEnd cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("periodStart", "Edm.DateTimeOffset", periodStart)
            .put("periodEnd", "Edm.DateTimeOffset", periodEnd)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getPrintUsageSummariesByGroup"), GroupPrintUsageSummary.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getPrintUsageSummariesByPrinter")
    @JsonIgnore
    public CollectionPageNonEntityRequest<PrinterUsageSummary> getPrintUsageSummariesByPrinter(OffsetDateTime periodStart, OffsetDateTime periodEnd) {
        Preconditions.checkNotNull(periodStart, "periodStart cannot be null");
        Preconditions.checkNotNull(periodEnd, "periodEnd cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("periodStart", "Edm.DateTimeOffset", periodStart)
            .put("periodEnd", "Edm.DateTimeOffset", periodEnd)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getPrintUsageSummariesByPrinter"), PrinterUsageSummary.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getOverallPrintUsageSummary")
    @JsonIgnore
    public CollectionPageNonEntityRequest<OverallPrintUsageSummary> getOverallPrintUsageSummary(OffsetDateTime periodStart, OffsetDateTime periodEnd, Integer topListsSize) {
        Preconditions.checkNotNull(periodStart, "periodStart cannot be null");
        Preconditions.checkNotNull(periodEnd, "periodEnd cannot be null");
        Preconditions.checkNotNull(topListsSize, "topListsSize cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("periodStart", "Edm.DateTimeOffset", periodStart)
            .put("periodEnd", "Edm.DateTimeOffset", periodEnd)
            .put("topListsSize", "Edm.Int32", topListsSize)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getOverallPrintUsageSummary"), OverallPrintUsageSummary.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

    @Function(name = "getPrintUsageSummariesByTimeSpan")
    @JsonIgnore
    public CollectionPageNonEntityRequest<PrintUsageSummary> getPrintUsageSummariesByTimeSpan(OffsetDateTime periodStart, OffsetDateTime periodEnd, Integer timeSpanInMinutes) {
        Preconditions.checkNotNull(periodStart, "periodStart cannot be null");
        Preconditions.checkNotNull(periodEnd, "periodEnd cannot be null");
        Preconditions.checkNotNull(timeSpanInMinutes, "timeSpanInMinutes cannot be null");
        Map<String, TypedObject> _parameters = ParameterMap
            .put("periodStart", "Edm.DateTimeOffset", periodStart)
            .put("periodEnd", "Edm.DateTimeOffset", periodEnd)
            .put("timeSpanInMinutes", "Edm.Int32", timeSpanInMinutes)
            .build();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.getPrintUsageSummariesByTimeSpan"), PrintUsageSummary.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
