package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.PurchaseInvoice;
import odata.msgraph.client.beta.entity.request.PurchaseInvoiceLineRequest;
import odata.msgraph.client.beta.entity.request.PurchaseInvoiceRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class PurchaseInvoiceCollectionRequest extends CollectionPageEntityRequest<PurchaseInvoice, PurchaseInvoiceRequest>{

    protected ContextPath contextPath;

    public PurchaseInvoiceCollectionRequest(ContextPath contextPath) {
        super(contextPath, PurchaseInvoice.class, cp -> new PurchaseInvoiceRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public PurchaseInvoiceLineCollectionRequest purchaseInvoiceLines() {
        return new PurchaseInvoiceLineCollectionRequest(contextPath.addSegment("purchaseInvoiceLines"));
    }

    public PurchaseInvoiceLineRequest purchaseInvoiceLines(String id) {
        return new PurchaseInvoiceLineRequest(contextPath.addSegment("purchaseInvoiceLines").addKeys(new NameValue(id.toString())));
    }



}
