package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.PublishedResource;
import odata.msgraph.client.beta.entity.request.OnPremisesAgentGroupRequest;
import odata.msgraph.client.beta.entity.request.PublishedResourceRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class PublishedResourceCollectionRequest extends CollectionPageEntityRequest<PublishedResource, PublishedResourceRequest>{

    protected ContextPath contextPath;

    public PublishedResourceCollectionRequest(ContextPath contextPath) {
        super(contextPath, PublishedResource.class, cp -> new PublishedResourceRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public OnPremisesAgentGroupCollectionRequest agentGroups() {
        return new OnPremisesAgentGroupCollectionRequest(contextPath.addSegment("agentGroups"));
    }

    public OnPremisesAgentGroupRequest agentGroups(String id) {
        return new OnPremisesAgentGroupRequest(contextPath.addSegment("agentGroups").addKeys(new NameValue(id.toString())));
    }

}
