package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.Program;
import odata.msgraph.client.beta.entity.request.ProgramControlRequest;
import odata.msgraph.client.beta.entity.request.ProgramRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class ProgramCollectionRequest extends CollectionPageEntityRequest<Program, ProgramRequest>{

    protected ContextPath contextPath;

    public ProgramCollectionRequest(ContextPath contextPath) {
        super(contextPath, Program.class, cp -> new ProgramRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }

    public ProgramControlCollectionRequest controls() {
        return new ProgramControlCollectionRequest(contextPath.addSegment("controls"));
    }

    public ProgramControlRequest controls(String id) {
        return new ProgramControlRequest(contextPath.addSegment("controls").addKeys(new NameValue(id.toString())));
    }

}
