package odata.msgraph.client.beta.entity.collection.request;

import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.NameValue;

import odata.msgraph.client.beta.entity.PrivilegedRole;
import odata.msgraph.client.beta.entity.request.PrivilegedRoleAssignmentRequest;
import odata.msgraph.client.beta.entity.request.PrivilegedRoleRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class PrivilegedRoleCollectionRequest extends CollectionPageEntityRequest<PrivilegedRole, PrivilegedRoleRequest>{

    protected ContextPath contextPath;

    public PrivilegedRoleCollectionRequest(ContextPath contextPath) {
        super(contextPath, PrivilegedRole.class, cp -> new PrivilegedRoleRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }


    public PrivilegedRoleAssignmentCollectionRequest assignments() {
        return new PrivilegedRoleAssignmentCollectionRequest(contextPath.addSegment("assignments"));
    }

    public PrivilegedRoleAssignmentRequest assignments(String id) {
        return new PrivilegedRoleAssignmentRequest(contextPath.addSegment("assignments").addKeys(new NameValue(id.toString())));
    }


}
