package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.PrivilegedRoleAssignmentRequest;
import odata.msgraph.client.beta.entity.request.PrivilegedRoleAssignmentRequestRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class PrivilegedRoleAssignmentRequestCollectionRequest extends CollectionPageEntityRequest<PrivilegedRoleAssignmentRequest, PrivilegedRoleAssignmentRequestRequest>{

    protected ContextPath contextPath;

    public PrivilegedRoleAssignmentRequestCollectionRequest(ContextPath contextPath) {
        super(contextPath, PrivilegedRoleAssignmentRequest.class, cp -> new PrivilegedRoleAssignmentRequestRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }


    @Function(name = "my")
    @JsonIgnore
    public CollectionPageNonEntityRequest<PrivilegedRoleAssignmentRequest> my() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.my"), PrivilegedRoleAssignmentRequest.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
