package odata.msgraph.client.beta.entity.collection.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.github.davidmoten.odata.client.CollectionPageEntityRequest;
import com.github.davidmoten.odata.client.CollectionPageNonEntityRequest;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.annotation.Function;
import com.github.davidmoten.odata.client.internal.ParameterMap;
import com.github.davidmoten.odata.client.internal.TypedObject;

import java.util.Map;

import odata.msgraph.client.beta.entity.PrivilegedRoleAssignment;
import odata.msgraph.client.beta.entity.request.PrivilegedRoleAssignmentRequest;
import odata.msgraph.client.beta.schema.SchemaInfo;

public class PrivilegedRoleAssignmentCollectionRequest extends CollectionPageEntityRequest<PrivilegedRoleAssignment, PrivilegedRoleAssignmentRequest>{

    protected ContextPath contextPath;

    public PrivilegedRoleAssignmentCollectionRequest(ContextPath contextPath) {
        super(contextPath, PrivilegedRoleAssignment.class, cp -> new PrivilegedRoleAssignmentRequest(cp), SchemaInfo.INSTANCE);
        this.contextPath = contextPath;
    }


    @Function(name = "my")
    @JsonIgnore
    public CollectionPageNonEntityRequest<PrivilegedRoleAssignment> my() {
        Map<String, TypedObject> _parameters = ParameterMap.empty();
        return CollectionPageNonEntityRequest.forAction(this.contextPath.addActionOrFunctionSegment("microsoft.graph.my"), PrivilegedRoleAssignment.class, _parameters, odata.msgraph.client.beta.schema.SchemaInfo.INSTANCE);
    }

}
